-- new script file

local foWave = {}
local mission = {}

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("foAtt")
end

function OnThink(self)
  if not self.initialized then
		self.initialized = true
		
		if not self.loaded then
			self.attackCounter = 0
			self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
			self.active = false
		end
		
		mission.enemy = Citadels.GetPlayer(1)
		self.wayPoint1 = Game:GetEntity('fortSiege'):GetPosition()
    self.wayPoint2 = Game:GetEntity('fortSquare'):GetPosition()
  end
  
  if self.active then
    if self.attackCounter > 0 then 
      UpgradeWave(self) 
	end
    InitializeWave(self)
    AttackWave(self)
    self.active = false
  end  
end

function InitializeWave(self)
  foWave['unit_L_arbalist_L1'] = self.baseCount * 0.12
  foWave['unit_L_archer_L3'] = self.baseCount * 0.1
  foWave['unit_L_fman_L2'] = self.baseCount * 0.12
  foWave['unit_L_fman_L3'] = self.baseCount * 0.08
  foWave['unit_L_rider_L2'] = self.baseCount * 0.08
end

function UpgradeWave(self)
  self.baseCount = self.baseCount + 10
end

function AttackWave(self)
  for prefab,ammount in pairs(foWave) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint1)
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint2)
  mission.enemy:AttackGroupMaxWaitTimeForUnitsCreation(10)
  mission.enemy:AttackGroupCommit(1, self:GetPosition(), 20)
end

function OnTrigger(self, source, target)
  if target == "foAtt" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
		self.attackCounter = ar:Read()
		self.baseCount = ar:Read()
		self.active = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.attackCounter)
		ar:Write(self.baseCount)
		ar:Write(self.active)
  end
end
